const API_BASE = '/api';

let authToken = null;

export const setAuthToken = (token) => {
    authToken = token;
};

const getHeaders = () => {
    const headers = {
        "Content-Type": "application/json"
    };
    if (authToken) {
        headers["Authorization"] = `Bearer ${authToken}`;
    }
    return headers;
};

// --- Auth / Admin ---

export const getAuthStatus = async () => {
    const res = await fetch(`${API_BASE}/auth/status`, { headers: getHeaders() });
    if (!res.ok) throw new Error("Failed to get auth status");
    return res.json();
};

export const getAdminUsers = async () => {
    const res = await fetch(`${API_BASE}/admin/users`, { headers: getHeaders() });
    if (!res.ok) throw new Error("Failed to get users");
    return res.json();
};

export const adminApproveUser = async (uid, approved) => {
    const res = await fetch(`${API_BASE}/admin/approve`, {
        method: "POST",
        headers: getHeaders(),
        body: JSON.stringify({ uid, approved })
    });
    if (!res.ok) throw new Error("Failed to approve user");
    return res.json();
};

// --- Tasks ---

export const getTasks = async () => {
    const res = await fetch(`${API_BASE}/tasks`, { headers: getHeaders() });
    if (!res.ok) throw new Error("Failed to fetch tasks");
    return res.json();
};

export const saveTasks = async (tasks) => {
    const res = await fetch(`${API_BASE}/tasks`, {
        method: 'POST',
        headers: getHeaders(),
        body: JSON.stringify({ tasks })
    });
    return res.json();
};

export const deleteTask = async (id) => {
    const res = await fetch(`${API_BASE}/tasks/${id}`, {
        method: 'DELETE',
        headers: getHeaders()
    });
    return res.json();
};

export const getSheets = async () => {
    const res = await fetch(`${API_BASE}/sheets`, { headers: getHeaders() });
    if (!res.ok) throw new Error("Failed to fetch sheets");
    return res.json();
};

export const saveSheets = async (sheets) => {
    const res = await fetch(`${API_BASE}/sheets`, {
        method: 'POST',
        headers: getHeaders(),
        body: JSON.stringify(sheets)
    });
    return res.json();
};

export const getSettings = async () => {
    const res = await fetch(`${API_BASE}/settings`, { headers: getHeaders() });
    if (!res.ok) return {};
    return res.json();
};

export const saveSettings = async (settings) => {
    const res = await fetch(`${API_BASE}/settings`, {
        method: 'POST',
        headers: getHeaders(),
        body: JSON.stringify(settings)
    });
    return res.json();
};

export const log = async (level, message) => {
    // Fire and forget log
    fetch(`${API_BASE}/logs`, {
        method: 'POST',
        headers: getHeaders(),
        body: JSON.stringify({ timestamp: new Date().toLocaleTimeString(), level, message })
    }).catch(err => console.error(err));
};

export const getLogs = async () => {
    const res = await fetch(`${API_BASE}/logs`, { headers: getHeaders() });
    return res.json();
};
